/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.util.zip.Inflater;

public class ImageData {
    int[][] data = null;
    byte[] exp = null;
    ptviewer pv = null;
    boolean isfloat = false;
    int width = 0;
    int height = 0;
    byte[] lugamma = null;
    int[] ldtab = null;
    double gamma = 1.0;

    byte[] initgamma(double d) {
        double d2 = 1.0 / d;
        int n = (int)Math.pow(255.0, d);
        byte[] byArray = new byte[n];
        byArray[0] = 0;
        int n2 = 1;
        while (n2 < n) {
            int n3 = (int)(Math.pow(n2, d2) + 0.5);
            if (n3 > 255) {
                n3 = 255;
            }
            byArray[n2] = (byte)n3;
            ++n2;
        }
        return byArray;
    }

    void setLut(double d) {
        if (this.ldtab == null) {
            return;
        }
        d = Math.pow(d, this.gamma);
        this.ldtab[0] = 0;
        int n = 0;
        while (n < this.ldtab.length) {
            double d2 = d * Math.pow(2.0, (double)n - 128.0) + 0.5;
            this.ldtab[n] = d2 >= 2.147483647E9 ? Integer.MAX_VALUE : (int)d2;
            ++n;
        }
    }

    public ImageData(int[][] nArray, ptviewer ptviewer2) {
        this.pv = ptviewer2;
        this.width = nArray[0].length;
        this.height = nArray.length;
        this.data = nArray;
    }

    public ImageData(Image image, ptviewer ptviewer2) {
        int[][] nArray;
        this.pv = ptviewer2;
        this.width = image.getWidth(ptviewer2);
        this.height = image.getHeight(ptviewer2);
        try {
            nArray = new int[image.getHeight(ptviewer2)][image.getWidth(ptviewer2)];
        }
        catch (Exception exception) {
            this.pv.fatal = true;
            return;
        }
        this.pv.ptImageTo2DArray(nArray, image);
        if (nArray == null) {
            this.pv.fatal = true;
        }
        this.data = nArray;
    }

    public ImageData(String string, ptviewer ptviewer2, boolean bl, double d, double d2) {
        this.gamma = d2;
        this.lugamma = this.initgamma(d2);
        this.ldtab = new int[256];
        this.pv = ptviewer2;
        byte[] byArray = null;
        if (bl) {
            this.pv.percent[0] = 0;
            byArray = this.pv.file_read(string, this.pv.percent);
        } else {
            byArray = this.pv.file_read(string, null);
        }
        if (byArray == null) {
            this.pv.fatal = true;
            return;
        }
        if (string.toLowerCase().endsWith(".fjpg")) {
            this.isfloat = true;
            this.decodeFJPG(byArray);
        } else if (string.toLowerCase().endsWith(".pic") || string.toLowerCase().endsWith(".hdr") || string.toLowerCase().endsWith(".img")) {
            this.isfloat = true;
            this.decodeRADIANCE(byArray);
        } else {
            int[][] nArray;
            Image image = Toolkit.getDefaultToolkit().createImage(byArray);
            MediaTracker mediaTracker = new MediaTracker(this.pv);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                this.pv.fatal = true;
                return;
            }
            this.width = image.getWidth(this.pv);
            this.height = image.getHeight(this.pv);
            try {
                nArray = new int[this.height][this.width];
            }
            catch (Exception exception) {
                this.pv.fatal = true;
                return;
            }
            this.pv.ptImageTo2DArray(nArray, image);
            image = null;
            if (nArray == null) {
                this.pv.fatal = true;
            }
            this.data = nArray;
        }
        byArray = null;
        if (this.data == null) {
            this.pv.fatal = true;
        }
        if (bl) {
            this.pv.percent[0] = 100;
            this.pv.repaint();
        }
    }

    void decodeRADIANCE(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n = this.decodeRADIANCE_header(byArray);
        if (n < 0 || n >= byArray.length || this.width <= 0 || this.height <= 0) {
            return;
        }
        int[][] nArray = new int[this.height][this.width];
        if (nArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.height && n >= 0) {
            n = this.RGBE_ReadPixels_RLE(byArray, n, nArray[n2], this.width);
            ++n2;
        }
        if (n != byArray.length) {
            return;
        }
        this.exp = new byte[this.width * this.height];
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = n3 * this.width;
            int n5 = 0;
            while (n5 < this.width) {
                this.exp[n4 + n5] = (byte)(nArray[n3][n5] & 0xFF);
                nArray[n3][n5] = nArray[n3][n5] >> 8 | 0xFF000000;
                ++n5;
            }
            ++n3;
        }
        this.data = nArray;
    }

    int decodeRADIANCE_header(byte[] byArray) {
        int n = 3;
        while (n < byArray.length) {
            if (byArray[n - 3] == 10 && byArray[n - 2] == 45 && byArray[n - 1] == 89 && byArray[n] == 32) break;
            ++n;
        }
        if (++n >= byArray.length) {
            return -1;
        }
        int n2 = n + 1;
        while (n2 < byArray.length && byArray[n2] != 10) {
            ++n2;
        }
        if (n2 == byArray.length) {
            return -1;
        }
        String string = new String(byArray, n, n2 - n);
        int n3 = string.indexOf(88);
        if (n3 == -1) {
            return -1;
        }
        try {
            this.height = Double.valueOf(string.substring(0, n3 - 2)).intValue();
            this.width = Double.valueOf(string.substring(n3 + 2)).intValue();
        }
        catch (Exception exception) {
            return -1;
        }
        return n2 + 1;
    }

    /*
     * Unable to fully structure code
     */
    int RGBE_ReadPixels_RLE(byte[] var1_1, int var2_2, int[] var3_3, int var4_4) {
        if (var2_2 + 4 > var1_1.length) {
            return -1;
        }
        if (var1_1[var2_2] != 2 || var1_1[var2_2 + 1] != 2 || (var1_1[var2_2 + 2] & 128) != 0) {
            System.arraycopy(var1_1, var2_2, var3_3, 0, var4_4 * 4);
            return var2_2 + var4_4 * 4;
        }
        if ((var1_1[var2_2 + 2] << 8 | var1_1[var2_2 + 3]) != var4_4) {
            System.out.println("wrong scanline width");
            return -1;
        }
        var2_2 += 4;
        var7_5 = new byte[4][var4_4];
        var8_6 = new byte[2];
        var9_7 = 0;
        var5_8 = 0;
        while (var5_8 < 4) {
            var9_7 = 0;
            var10_10 = var4_4;
            while (var9_7 < var10_10) {
                block8: {
                    var8_6[0] = var1_1[var2_2++];
                    var8_6[1] = var1_1[var2_2++];
                    if ((var8_6[0] & 255) <= 128) break block8;
                    var6_9 = (var8_6[0] & 255) - 128;
                    if (var6_9 != 0 && var6_9 <= var10_10 - var9_7) ** GOTO lbl26
                    System.out.println("bad scanline data");
                    return -1;
lbl-1000:
                    // 1 sources

                    {
                        var7_5[var5_8][var9_7++] = var8_6[1];
lbl26:
                        // 2 sources

                        ** while (var6_9-- > 0)
                    }
lbl27:
                    // 1 sources

                    continue;
                }
                var6_9 = var8_6[0] & 255;
                if (var6_9 == 0 || var6_9 > var10_10 - var9_7) {
                    System.out.println("bad scanline data");
                    return -1;
                }
                var7_5[var5_8][var9_7++] = var8_6[1];
                if (--var6_9 <= 0) continue;
                System.arraycopy(var1_1, var2_2, var7_5[var5_8], var9_7, var6_9);
                var2_2 += var6_9;
                var9_7 += var6_9;
            }
            ++var5_8;
        }
        var11_11 = 0;
        while (var11_11 < var4_4) {
            var3_3[var11_11] = ((var7_5[0][var11_11] & 255) << 24) + ((var7_5[1][var11_11] & 255) << 16) + ((var7_5[2][var11_11] & 255) << 8) + (var7_5[3][var11_11] & 255);
            ++var11_11;
        }
        return var2_2;
    }

    void decodeFJPG(byte[] byArray) {
        int[][] nArray;
        if (byArray == null) {
            return;
        }
        int n = 0;
        int n2 = 1;
        while (n2 < byArray.length) {
            if (byArray[n2 - 1] == -1 && byArray[n2] == -39) {
                n = n2 + 1;
                break;
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        Image image = Toolkit.getDefaultToolkit().createImage(byArray2);
        MediaTracker mediaTracker = new MediaTracker(this.pv);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.width = image.getWidth(this.pv);
        this.height = image.getHeight(this.pv);
        try {
            nArray = new int[this.height][this.width];
        }
        catch (Exception exception) {
            return;
        }
        this.pv.ptImageTo2DArray(nArray, image);
        int n3 = (this.width + 7) / 8;
        int n4 = (this.height + 7) / 8;
        byte[] byArray3 = new byte[n3 * n4];
        try {
            Inflater inflater = new Inflater();
            inflater.setInput(byArray, n, byArray.length - n);
            inflater.inflate(byArray3);
            inflater.end();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.exp = new byte[this.height * this.width];
        int n5 = 0;
        while (n5 < this.height) {
            int n6 = 0;
            while (n6 < this.width) {
                this.exp[n5 * this.width + n6] = byArray3[(n5 >> 3) * n3 + (n6 >> 3)];
                ++n6;
            }
            ++n5;
        }
        byArray2 = null;
        image = null;
        this.data = nArray;
    }

    final int getPixel(int n, int n2) {
        if (this.isfloat) {
            int n3 = this.data[n2][n];
            int n4 = this.ldtab[this.exp[n2 * this.width + n] & 0xFF];
            int n5 = (n3 >> 16 & 0xFF) * n4 >>> 8;
            int n6 = n5 >= this.lugamma.length ? 255 : this.lugamma[n5] & 0xFF;
            int n7 = (n3 >> 8 & 0xFF) * n4 >>> 8;
            int n8 = n7 >= this.lugamma.length ? 255 : this.lugamma[n7] & 0xFF;
            int n9 = (n3 & 0xFF) * n4 >>> 8;
            int n10 = n9 >= this.lugamma.length ? 255 : this.lugamma[n9] & 0xFF;
            return n3 & 0xFF000000 | (n6 << 16) + (n8 << 8) + n10;
        }
        return this.data[n2][n];
    }

    final int getPixel(int n, int n2, int n3, int n4) {
        int n5 = 256 - n3;
        int n6 = 256 - n4;
        int n7 = n5 * n6;
        int n8 = n4 * n5;
        int n9 = n3 * n4;
        int n10 = n3 * n6;
        if (this.isfloat) {
            int n11 = this.data[n2][n + 1];
            int n12 = n2 * this.width + n;
            int n13 = this.ldtab[this.exp[n12 + 1] & 0xFF];
            int n14 = (n11 >> 16 & 0xFF) * n13 >>> 8;
            n14 = n14 >= this.lugamma.length ? 255 : this.lugamma[n14] & 0xFF;
            int n15 = (n11 >> 8 & 0xFF) * n13 >>> 8;
            n15 = n15 >= this.lugamma.length ? 255 : this.lugamma[n15] & 0xFF;
            int n16 = (n11 & 0xFF) * n13 >>> 8;
            n16 = n16 >= this.lugamma.length ? 255 : this.lugamma[n16] & 0xFF;
            n11 = this.data[n2 + 1][n];
            n13 = this.ldtab[this.exp[n12 + this.width] & 0xFF];
            int n17 = (n11 >> 16 & 0xFF) * n13 >>> 8;
            n17 = n17 >= this.lugamma.length ? 255 : this.lugamma[n17] & 0xFF;
            int n18 = (n11 >> 8 & 0xFF) * n13 >>> 8;
            n18 = n18 >= this.lugamma.length ? 255 : this.lugamma[n18] & 0xFF;
            int n19 = (n11 & 0xFF) * n13 >>> 8;
            n19 = n19 >= this.lugamma.length ? 255 : this.lugamma[n19] & 0xFF;
            n11 = this.data[n2 + 1][n + 1];
            n13 = this.ldtab[this.exp[n12 + this.width + 1] & 0xFF];
            int n20 = (n11 >> 16 & 0xFF) * n13 >>> 8;
            n20 = n20 >= this.lugamma.length ? 255 : this.lugamma[n20] & 0xFF;
            int n21 = (n11 >> 8 & 0xFF) * n13 >>> 8;
            n21 = n21 >= this.lugamma.length ? 255 : this.lugamma[n21] & 0xFF;
            int n22 = (n11 & 0xFF) * n13 >>> 8;
            n22 = n22 >= this.lugamma.length ? 255 : this.lugamma[n22] & 0xFF;
            n11 = this.data[n2][n];
            n13 = this.ldtab[this.exp[n12] & 0xFF];
            int n23 = (n11 >> 16 & 0xFF) * n13 >>> 8;
            n23 = n23 >= this.lugamma.length ? 255 : this.lugamma[n23] & 0xFF;
            int n24 = (n11 >> 8 & 0xFF) * n13 >>> 8;
            n24 = n24 >= this.lugamma.length ? 255 : this.lugamma[n24] & 0xFF;
            int n25 = (n11 & 0xFF) * n13 >>> 8;
            n25 = n25 >= this.lugamma.length ? 255 : this.lugamma[n25] & 0xFF;
            int n26 = n7 * n23 + n10 * n14 + n8 * n17 + n9 * n20 & 0xFF0000;
            int n27 = n7 * n24 + n10 * n15 + n8 * n18 + n9 * n21 >> 16;
            int n28 = n7 * n25 + n10 * n16 + n8 * n19 + n9 * n22 >> 16;
            return n26 + (n27 << 8) + n28 | n11 & 0xFF000000;
        }
        int n29 = this.data[n2][n];
        int n30 = this.data[n2][n + 1];
        int n31 = this.data[n2 + 1][n];
        int n32 = this.data[n2 + 1][n + 1];
        int n33 = n7 * (n29 >> 16 & 0xFF) + n10 * (n30 >> 16 & 0xFF) + n8 * (n31 >> 16 & 0xFF) + n9 * (n32 >> 16 & 0xFF) & 0xFF0000;
        int n34 = n7 * (n29 >> 8 & 0xFF) + n10 * (n30 >> 8 & 0xFF) + n8 * (n31 >> 8 & 0xFF) + n9 * (n32 >> 8 & 0xFF) >> 16;
        int n35 = n7 * (n29 & 0xFF) + n10 * (n30 & 0xFF) + n8 * (n31 & 0xFF) + n9 * (n32 & 0xFF) >> 16;
        return n33 + (n34 << 8) + n35 | n29 & 0xFF000000;
    }
}

