/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.PixelGrabber;
import java.io.BufferedInputStream;
import java.io.InputStream;

public class toolbar
implements Runnable {
    protected ptviewer ptv;
    protected int width;
    protected int height = 23;
    protected int xTlb;
    protected int yTlb;
    protected Image tlbImage;
    protected Graphics tlbGraph;
    protected Image[] buttons;
    protected int BTN_PLUS = 0;
    protected int BTN_PLUS_OVER = 1;
    protected int BTN_PLUS_PRESSED = 2;
    protected int BTN_MINUS = 3;
    protected int BTN_MINUS_OVER = 4;
    protected int BTN_MINUS_PRESSED = 5;
    protected int BTN_HS = 6;
    protected int BTN_HS_OVER = 7;
    protected int BTN_HS_PRESSED = 8;
    protected int BTN_HS_PRESSED_OVER = 9;
    protected int BTN_HS_DISABLED = 10;
    protected int N_BUTTONS = 11;
    protected int W_BUTTON = 27;
    protected int H_BUTTON = 19;
    protected int X_OFFSET = 1;
    protected int Y_OFFSET = 2;
    protected int BTN_STATUS_NORMAL = 0;
    protected int BTN_STATUS_OVER = 1;
    protected int BTN_STATUS_PRESSED = 2;
    protected int BTN_STATUS_PRESSED_OVER = 3;
    protected int BTN_STATUS_DISABLED = 4;
    protected int curStatusPlus = this.BTN_STATUS_NORMAL;
    protected int curStatusMinus = this.BTN_STATUS_NORMAL;
    protected int curStatusHS = this.BTN_STATUS_DISABLED;
    protected boolean isHSButtonPressed = false;
    protected boolean justPressedHSButton = false;
    private Thread zoomThread = null;
    protected Color barColor;
    protected Color borderColor;
    protected Color bgColor;
    protected Color textColor;
    protected Color textDefaultColor;
    protected int BAR_X_OFFSET = 89;
    protected int BAR_Y_OFFSET = 7;
    protected int BAR_HEIGHT = 9;
    protected int barX;
    protected int barY;
    protected int barTotWidth;
    protected int barPerc = 0;
    protected boolean paintFinished = true;
    protected String msg;
    Font msgFont;
    int xMessage;
    int yMessage;

    public toolbar(ptviewer ptviewer2, String string) {
        this.ptv = ptviewer2;
        this.msg = "";
        this.msgFont = null;
        this.textColor = this.textDefaultColor = Color.black;
        this.buttons = new Image[this.N_BUTTONS];
        this.loadButtonImages(string);
        this.xMessage = this.BAR_X_OFFSET;
    }

    protected void createFont(Graphics graphics) {
        boolean bl = false;
        Font font = graphics.getFont();
        int n = 19;
        int n2 = 5;
        Font font2 = graphics.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = font2.getSize();
        String string = font2.getName();
        int n4 = font2.getStyle();
        while (!bl) {
            if (fontMetrics.getHeight() <= n) {
                bl = true;
                continue;
            }
            if (n3 <= n2) {
                bl = true;
                continue;
            }
            font2 = new Font(string, n4, --n3);
            graphics.setFont(font2);
            fontMetrics = graphics.getFontMetrics();
        }
        this.yMessage = this.yTlb + this.height - (this.height - fontMetrics.getAscent()) / 2 - 2;
        this.msgFont = graphics.getFont();
        graphics.setFont(font);
    }

    public void setMessage(String string) {
        this.msg = string;
        this.textColor = this.textDefaultColor;
    }

    public void setMessage(String string, Color color) {
        this.msg = string;
        this.textColor = color;
    }

    public void run() {
        int n = this.ptv.getQuality();
        if (n > 3) {
            this.ptv.setQuality(3);
        }
        Thread thread = Thread.currentThread();
        while (this.zoomThread == thread) {
            long l = System.currentTimeMillis();
            this.paintFinished = false;
            if (thread.getName().equals("zoomin")) {
                this.ptv.ZoomIn();
            }
            if (thread.getName().equals("zoomout")) {
                this.ptv.ZoomOut();
            }
            Thread.yield();
            while (!this.paintFinished) {
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            l = System.currentTimeMillis() - l;
            if (l >= 50L) continue;
            try {
                Thread.sleep(50L - l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n > 3) {
            this.ptv.setQuality(n);
            this.ptv.repaint();
        }
    }

    public void notifyEndPaint() {
        this.paintFinished = true;
    }

    public void setViewerSize(int n, int n2, int n3, int n4) {
        this.width = n;
        this.xTlb = n3;
        this.yTlb = n2 - this.height + n4;
        this.barX = this.BAR_X_OFFSET;
        this.barY = this.BAR_Y_OFFSET;
        this.barTotWidth = this.width - this.BAR_X_OFFSET - 9;
        this.tlbImage = this.ptv.createImage(this.width, this.height);
        this.tlbGraph = this.tlbImage.getGraphics();
    }

    public void setBarPerc(int n) {
        this.barPerc = n;
    }

    public void setToolbarDescrX(int n) {
        if (n > 0) {
            this.xMessage = n;
        }
    }

    public void paint(Graphics graphics) {
        if (this.msgFont == null) {
            this.createFont(graphics);
        }
        this.drawToolbar();
        this.drawProgressBar();
        graphics.drawImage(this.tlbImage, this.xTlb, this.yTlb, this.ptv);
        if (this.msg != "") {
            Color color = graphics.getColor();
            graphics.setColor(this.textColor);
            Font font = graphics.getFont();
            graphics.setFont(this.msgFont);
            graphics.drawString(this.msg, this.xMessage, this.yMessage);
            graphics.setFont(font);
            graphics.setColor(color);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void toggleHSButton() {
        if (this.ptv.numhs == 0) {
            return;
        }
        this.curStatusHS = this.isHSButtonPressed ? (this.curStatusHS == this.BTN_STATUS_PRESSED_OVER ? this.BTN_STATUS_OVER : this.BTN_STATUS_NORMAL) : (this.curStatusHS == this.BTN_STATUS_OVER ? this.BTN_STATUS_PRESSED_OVER : this.BTN_STATUS_PRESSED);
        this.isHSButtonPressed = !this.isHSButtonPressed;
    }

    public void syncHSButton() {
        if (this.ptv.numhs == 0) {
            return;
        }
        if (this.ptv.showhs) {
            this.isHSButtonPressed = true;
            this.curStatusHS = this.curStatusHS == this.BTN_STATUS_OVER || this.curStatusHS == this.BTN_STATUS_PRESSED_OVER ? this.BTN_STATUS_PRESSED_OVER : this.BTN_STATUS_PRESSED;
        } else {
            this.isHSButtonPressed = false;
            this.curStatusHS = this.curStatusHS == this.BTN_STATUS_OVER || this.curStatusHS == this.BTN_STATUS_PRESSED_OVER ? this.BTN_STATUS_OVER : this.BTN_STATUS_NORMAL;
        }
    }

    public void mouseMove(int n, int n2) {
        if (this.overPlusButton(n, n2)) {
            if (this.curStatusPlus != this.BTN_STATUS_OVER) {
                this.curStatusPlus = this.BTN_STATUS_OVER;
                this.ptv.repaint();
            }
        } else if (this.curStatusPlus != this.BTN_STATUS_NORMAL) {
            this.curStatusPlus = this.BTN_STATUS_NORMAL;
            this.ptv.repaint();
        }
        if (this.overMinusButton(n, n2)) {
            if (this.curStatusMinus != this.BTN_STATUS_OVER) {
                this.curStatusMinus = this.BTN_STATUS_OVER;
                this.ptv.repaint();
            }
        } else if (this.curStatusMinus != this.BTN_STATUS_NORMAL) {
            this.curStatusMinus = this.BTN_STATUS_NORMAL;
            this.ptv.repaint();
        }
        if (this.ptv.numhs > 0) {
            if (this.overHSButton(n, n2)) {
                if (!this.isHSButtonPressed && this.curStatusHS != this.BTN_STATUS_OVER) {
                    this.curStatusHS = this.BTN_STATUS_OVER;
                    this.ptv.repaint();
                } else if (this.isHSButtonPressed && this.curStatusHS != this.BTN_STATUS_PRESSED_OVER) {
                    this.curStatusHS = this.BTN_STATUS_PRESSED_OVER;
                    this.ptv.repaint();
                }
            } else if (!this.isHSButtonPressed && this.curStatusHS != this.BTN_STATUS_NORMAL) {
                this.curStatusHS = this.BTN_STATUS_NORMAL;
                this.ptv.repaint();
            } else if (this.isHSButtonPressed && this.curStatusHS != this.BTN_STATUS_PRESSED) {
                this.curStatusHS = this.BTN_STATUS_PRESSED;
                this.ptv.repaint();
            }
        }
    }

    public void mouseDown(int n, int n2) {
        this.justPressedHSButton = false;
        if (this.overPlusButton(n, n2)) {
            this.justPressedHSButton = false;
            this.curStatusPlus = this.BTN_STATUS_PRESSED;
            this.zoomThread = new Thread((Runnable)this, "zoomin");
            this.zoomThread.start();
        }
        if (this.overMinusButton(n, n2)) {
            this.justPressedHSButton = false;
            this.curStatusMinus = this.BTN_STATUS_PRESSED;
            this.zoomThread = new Thread((Runnable)this, "zoomout");
            this.zoomThread.start();
        }
        if (this.ptv.numhs > 0 && this.overHSButton(n, n2)) {
            boolean bl = this.justPressedHSButton = !this.isHSButtonPressed;
            if (!this.isHSButtonPressed) {
                this.curStatusHS = this.BTN_STATUS_PRESSED_OVER;
                this.isHSButtonPressed = !this.isHSButtonPressed;
                this.ptv.showHS();
            }
        }
    }

    public void mouseUp(int n, int n2) {
        if (this.overPlusButton(n, n2)) {
            this.curStatusPlus = this.BTN_STATUS_OVER;
            this.zoomThread = null;
        }
        if (this.overMinusButton(n, n2)) {
            this.curStatusMinus = this.BTN_STATUS_OVER;
            this.zoomThread = null;
        }
        if (this.ptv.numhs > 0 && this.overHSButton(n, n2) && this.isHSButtonPressed && !this.justPressedHSButton) {
            this.curStatusHS = this.BTN_STATUS_OVER;
            this.isHSButtonPressed = !this.isHSButtonPressed;
            this.ptv.hideHS();
        }
    }

    public void mouseDrag(int n, int n2) {
        if (!this.overPlusButton(n, n2) && this.curStatusPlus != this.BTN_STATUS_NORMAL) {
            this.curStatusPlus = this.BTN_STATUS_NORMAL;
            this.zoomThread = null;
            this.ptv.repaint();
        }
        if (!this.overMinusButton(n, n2) && this.curStatusMinus != this.BTN_STATUS_NORMAL) {
            this.curStatusMinus = this.BTN_STATUS_NORMAL;
            this.zoomThread = null;
            this.ptv.repaint();
        }
    }

    public void mouseExit(int n, int n2) {
        this.curStatusPlus = this.BTN_STATUS_NORMAL;
        this.curStatusMinus = this.BTN_STATUS_NORMAL;
        if (this.ptv.numhs > 0) {
            this.curStatusHS = this.isHSButtonPressed ? this.BTN_STATUS_PRESSED : this.BTN_STATUS_NORMAL;
        }
        this.ptv.repaint();
    }

    public void SetTextColor(String string) {
        try {
            this.textDefaultColor = new Color(Integer.parseInt(string, 16));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean overPlusButton(int n, int n2) {
        return this.overButtonN(n, n2, 0);
    }

    protected boolean overMinusButton(int n, int n2) {
        return this.overButtonN(n, n2, 1);
    }

    protected boolean overHSButton(int n, int n2) {
        return this.overButtonN(n, n2, 2);
    }

    protected boolean overButtonN(int n, int n2, int n3) {
        if (n < this.xTlb + this.X_OFFSET + 1 + this.W_BUTTON * n3) {
            return false;
        }
        if (n > this.xTlb + this.X_OFFSET + this.W_BUTTON - 2 + this.W_BUTTON * n3) {
            return false;
        }
        if (n2 < this.yTlb + this.Y_OFFSET + 1) {
            return false;
        }
        return n2 <= this.yTlb + this.Y_OFFSET + this.H_BUTTON - 2;
    }

    protected void loadButtonImages(String string) {
        Image image;
        Object object;
        if (string == null) {
            try {
                MediaTracker mediaTracker = new MediaTracker(this.ptv);
                object = this.getClass().getResourceAsStream("Toolbar.gif");
                BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
                byte[] byArray = new byte[10000];
                int n = bufferedInputStream.read(byArray, 0, 10000);
                image = Toolkit.getDefaultToolkit().createImage(byArray);
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForAll();
            }
            catch (Exception exception) {
                image = null;
            }
        } else {
            image = this.ptv.loadImage(string);
        }
        int n = 0;
        while (n < this.N_BUTTONS) {
            object = new CropImageFilter(1 + n * this.W_BUTTON, 2, this.W_BUTTON, this.H_BUTTON);
            this.buttons[n] = this.ptv.createImage(new FilteredImageSource(image.getSource(), (ImageFilter)object));
            this.ptv.prepareImage(this.buttons[n], this.ptv);
            ++n;
        }
        this.extractColors(image);
    }

    protected void drawButton(int n, int n2, int n3) {
        this.tlbGraph.drawImage(this.buttons[n], n2, n3, this.ptv);
    }

    protected void drawPlusButton(int n) {
        int n2 = n;
        this.drawButton(n2, this.X_OFFSET, this.Y_OFFSET);
        this.curStatusPlus = n;
    }

    protected void drawMinusButton(int n) {
        int n2 = n + 3;
        this.drawButton(n2, this.X_OFFSET + this.W_BUTTON + 1, this.Y_OFFSET);
        this.curStatusMinus = n;
    }

    protected void drawHSButton(int n) {
        int n2 = n + 6;
        this.drawButton(n2, this.X_OFFSET + this.W_BUTTON * 2 + 1, this.Y_OFFSET);
        this.curStatusHS = n;
    }

    protected void drawToolbar() {
        this.tlbGraph.setColor(this.borderColor);
        this.tlbGraph.drawRect(0, 0, this.width - 1, this.height - 1);
        this.tlbGraph.setColor(this.bgColor);
        this.tlbGraph.fillRect(1, 1, this.width - 2, this.height - 2);
        this.drawPlusButton(this.curStatusPlus);
        this.drawMinusButton(this.curStatusMinus);
        if (this.ptv.numhs > 0 && this.curStatusHS == this.BTN_STATUS_DISABLED) {
            this.curStatusHS = this.BTN_STATUS_NORMAL;
        }
        this.drawHSButton(this.curStatusHS);
    }

    protected void extractColors(Image image) {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[1];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, nArray, 0, 1);
        try {
            pixelGrabber.grabPixels();
            n3 = nArray[0] >> 16 & 0xFF;
            n2 = nArray[0] >> 8 & 0xFF;
            n = nArray[0] & 0xFF;
            this.borderColor = new Color(n3, n2, n);
        }
        catch (Exception exception) {
            this.borderColor = new Color(0, 0, 0);
        }
        pixelGrabber = new PixelGrabber(image, 306, 11, 1, 1, nArray, 0, 1);
        try {
            pixelGrabber.grabPixels();
            n3 = nArray[0] >> 16 & 0xFF;
            n2 = nArray[0] >> 8 & 0xFF;
            n = nArray[0] & 0xFF;
            this.barColor = new Color(n3, n2, n);
        }
        catch (Exception exception) {
            this.barColor = new Color(0, 60, 116);
        }
        pixelGrabber = new PixelGrabber(image, 298, 11, 1, 1, nArray, 0, 1);
        try {
            pixelGrabber.grabPixels();
            n3 = nArray[0] >> 16 & 0xFF;
            n2 = nArray[0] >> 8 & 0xFF;
            n = nArray[0] & 0xFF;
            this.bgColor = new Color(n3, n2, n);
        }
        catch (Exception exception) {
            this.bgColor = new Color(236, 233, 216);
        }
    }

    protected void drawProgressBar() {
        if (this.barPerc <= 0 || this.barPerc > 100) {
            return;
        }
        int n = this.barTotWidth * this.barPerc / 100;
        this.tlbGraph.setColor(this.barColor);
        this.tlbGraph.fillRect(this.barX, this.barY, n, this.BAR_HEIGHT);
    }
}

