/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class PTVFile {
    static final int VERSION = 1;
    String fileName;
    protected ptviewer ptv;
    protected DirectoryEntry[] tileData;
    protected DirectoryEntry previewData;
    protected int nTiles;
    protected int pWidth;
    protected int pHeight;
    protected int dirHeaderSize;
    protected int dirEntrySize;
    protected int dirOffset;
    protected int bitFlags;
    protected int nRows;
    protected int nCols;
    protected boolean hasPreview;
    protected byte[] fullImageBuffer;
    protected boolean usePartialGet;
    protected boolean usingMSVM;
    HttpGetReader hgr = null;

    public PTVFile(ptviewer ptviewer2, String string) {
        this.ptv = ptviewer2;
        this.fileName = string;
        this.fullImageBuffer = null;
        boolean bl = this.usingMSVM = System.getProperty("java.vendor").toLowerCase().indexOf("microsoft") >= 0;
        if (this.usingMSVM) {
            System.out.println("PTViewer: running in the Microsoft VM");
            this.hgr = new HttpGetReader(ptviewer2);
        }
        this.loadHeaderData();
    }

    public Image loadPreviewImage() {
        byte[] byArray = null;
        if (!this.hasPreview) {
            return null;
        }
        if (this.usePartialGet && (byArray = this.doPartialGet(this.previewData.offset, this.previewData.size)) == null) {
            this.usePartialGet = false;
            System.out.println("PTViewer: abandoned dynamic loading");
            this.loadWholeFile();
        }
        if (!this.usePartialGet) {
            byArray = new byte[this.previewData.size];
            System.arraycopy(this.fullImageBuffer, this.previewData.offset, byArray, 0, this.previewData.size);
        }
        Image image = this.ptv.bufferToImage(byArray);
        return image;
    }

    protected void loadWholeFile() {
        System.out.println("PTViewer: loading whole file");
        this.ptv.percent[0] = 0;
        this.fullImageBuffer = this.ptv.file_read(this.fileName, this.ptv.percent);
        if (this.fullImageBuffer == null) {
            System.out.println("PTViewer: unable to load panorama file: probably file not found");
            this.ptv.fatal = true;
            this.ptv.repaint();
        }
        this.extractHeaderData(this.fullImageBuffer);
        this.extractDirectory(this.fullImageBuffer);
    }

    protected void loadHeaderData() {
        if (this.ptv.getDocumentBase().toString().toLowerCase().startsWith("file:")) {
            this.usePartialGet = false;
            System.out.println("PTViewer: reading a local image file");
        } else {
            this.usePartialGet = true;
            byte[] byArray = this.doPartialGet(0, 2000);
            if (byArray == null) {
                System.out.println("PTViewer: abandoned dynamic loading");
                this.usePartialGet = false;
            } else {
                this.extractHeaderData(byArray);
                this.extractDirectory(byArray);
            }
        }
        if (!this.usePartialGet) {
            this.loadWholeFile();
        }
    }

    protected byte[] doPartialGet(int n, int n2) {
        if (this.usingMSVM) {
            return this.hgr.doPartialGet(this.fileName, n, n2);
        }
        try {
            int n3;
            URL uRL = new URL(this.ptv.getDocumentBase(), this.fileName);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            String string = "bytes=" + n + "-" + (n + n2 - 1);
            httpURLConnection.setRequestProperty("Range", string);
            httpURLConnection.connect();
            int n4 = httpURLConnection.getResponseCode();
            InputStream inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[n2];
            if (n4 != 206) {
                System.out.println("PTViewer: unexpected response code: " + n4);
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[4096];
            while ((n3 = inputStream.read(byArray2)) >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n3);
            }
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            int n5 = byArray.length;
            if (n5 != n2) {
                System.out.println("PTViewer: number of returned bytes does not match. Requested: " + n2 + "   Returned: " + n5);
                return null;
            }
            return byArray;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
    }

    protected Image loadTileImage(DirectoryEntry directoryEntry) {
        byte[] byArray = null;
        if (this.usePartialGet && (byArray = this.doPartialGet(directoryEntry.offset, directoryEntry.size)) == null) {
            this.usePartialGet = false;
            System.out.println("PTViewer: abandoned dynamic loading");
            this.loadWholeFile();
        }
        if (!this.usePartialGet) {
            byArray = new byte[directoryEntry.size];
            System.arraycopy(this.fullImageBuffer, directoryEntry.offset, byArray, 0, directoryEntry.size);
        }
        Image image = this.ptv.bufferToImage(byArray);
        return image;
    }

    protected void loadTileInPTViewer(DirectoryEntry directoryEntry) {
        if (directoryEntry.loaded) {
            return;
        }
        this.ptv.loadingROI = true;
        Image image = null;
        image = this.loadTileImage(directoryEntry);
        if (image != null) {
            this.ptv.ptinsertImage(this.ptv.pdata, directoryEntry.xPosInPano, directoryEntry.yPosInPano, image, (this.ptv.pheight + 99) / 100);
            if (this.ptv.hsready) {
                int n = 0;
                while (n < this.ptv.numhs) {
                    if ((this.ptv.hs_imode[n] & 4) > 0) {
                        int n2 = (int)this.ptv.hs_up[n];
                        int n3 = (int)this.ptv.hs_vp[n];
                        int n4 = (int)this.ptv.hs_xp[n] - n2 / 2;
                        int n5 = (int)this.ptv.hs_yp[n] - n3 / 2;
                        this.ptv.im_extractRect(this.ptv.pdata, n4, n5, (int[])this.ptv.hs_him[n], n2, 0, n3, n2, n3);
                    }
                    ++n;
                }
            }
            directoryEntry.loaded = true;
            image = null;
        }
        this.ptv.loadingROI = false;
    }

    public void loadTiles() {
        boolean bl;
        int n = 0;
        this.computeYawAngle();
        this.computePitchAngle();
        do {
            bl = true;
            int n2 = -1;
            int n3 = -1;
            double d = 10000.0;
            double d2 = 10000.0;
            int n4 = 0;
            while (n4 < this.nTiles) {
                if (!this.tileData[n4].loaded) {
                    bl = false;
                    double d3 = Math.abs(this.ptv.yaw - this.tileData[n4].yaw);
                    if (d3 > 180.0) {
                        d3 = 360.0 - d3;
                    }
                    double d4 = Math.abs(this.ptv.pitch - this.tileData[n4].pitch);
                    double d5 = Math.sqrt(d3 * d3 + d4 * d4);
                    if (this.isTileVisible(n4)) {
                        if (d5 < d) {
                            d = d5;
                            n2 = n4;
                        }
                    } else if (d5 < d2) {
                        d2 = d5;
                        n3 = n4;
                    }
                }
                ++n4;
            }
            n4 = n2 >= 0 ? n2 : n3;
            if (n4 < 0) continue;
            this.loadTileInPTViewer(this.tileData[n4]);
            ++n;
            if (this.ptv.showToolbar) {
                ((toolbar)this.ptv.tlbObj).setBarPerc(n * 100 / this.nTiles);
            }
            if (!this.isTileVisible(n4)) {
                this.ptv.onlyPaintToolbar = true;
            }
            this.ptv.paintDone = false;
            this.ptv.forceBilIntepolator = true;
            this.ptv.repaint();
            int n5 = 0;
            while (!this.ptv.paintDone && n5 < 100) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n5;
            }
        } while (!bl);
        if (this.ptv.showToolbar) {
            ((toolbar)this.ptv.tlbObj).setBarPerc(0);
        }
        this.ptv.dirty = true;
        this.ptv.repaint();
    }

    protected boolean isTileVisible(int n) {
        boolean bl = true;
        double d = Math.abs(this.ptv.yaw - this.tileData[n].yaw);
        if (d > 180.0) {
            d = 360.0 - d;
        }
        double d2 = Math.abs(this.ptv.pitch - this.tileData[n].pitch);
        if (d > (this.ptv.hfov + this.tileData[n].wDeg) / 2.0) {
            bl = false;
        }
        if (bl && d2 > (this.ptv.math_fovy(this.ptv.hfov, this.ptv.vwidth, this.ptv.vheight) + this.tileData[n].hDeg) / 2.0) {
            bl = false;
        }
        return bl;
    }

    protected void computeYawAngle() {
        int n = 0;
        while (n < this.nTiles) {
            double d = 360.0 * (double)(this.tileData[n].xPosInPano + this.tileData[n].width / 2) / (double)this.pWidth;
            if (d > 360.0) {
                d -= 360.0;
            }
            this.tileData[n].yaw = d -= 180.0;
            ++n;
        }
    }

    protected void computePitchAngle() {
        int n = 0;
        while (n < this.nTiles) {
            double d;
            int n2 = this.pWidth / 4 - this.pHeight / 2 + this.tileData[n].yPosInPano + this.tileData[n].height / 2;
            this.tileData[n].pitch = d = 90.0 - 180.0 * (double)n2 / (double)(this.pWidth / 2);
            ++n;
        }
    }

    protected void extractHeaderData(byte[] byArray) {
        int n;
        if (byArray[0] == 80 && byArray[1] == 86) {
            System.out.println("PTViewer: This is not a valid .ptv file");
            this.ptv.fatal = true;
            this.ptv.repaint();
        }
        if ((n = this.extractInt2(byArray, 2)) != 1) {
            System.out.println("PTViewer: unknown version for .ptv file");
            this.ptv.fatal = true;
            this.ptv.repaint();
        }
        this.pWidth = this.extractInt4(byArray, 4);
        this.pHeight = this.extractInt4(byArray, 8);
        this.dirHeaderSize = this.extractInt4(byArray, 12);
        this.dirEntrySize = this.extractInt4(byArray, 16);
        this.dirOffset = this.extractInt4(byArray, 20);
        this.bitFlags = this.extractInt4(byArray, 24);
    }

    protected void extractDirectory(byte[] byArray) {
        int n = this.dirOffset;
        this.nRows = this.extractInt2(byArray, n);
        this.nCols = this.extractInt2(byArray, n += 2);
        int n2 = this.extractInt2(byArray, n += 2);
        this.hasPreview = n2 != 0;
        this.nTiles = this.nRows * this.nCols;
        this.tileData = new DirectoryEntry[this.nTiles];
        this.previewData = this.hasPreview ? new DirectoryEntry() : null;
        int n3 = this.dirOffset + this.dirHeaderSize;
        if (this.hasPreview) {
            n3 += this.dirEntrySize;
        }
        if ((n3 += this.dirEntrySize * this.nTiles) > byArray.length && this.usePartialGet) {
            byArray = this.doPartialGet(0, n3 + 100);
        }
        n = this.dirOffset + this.dirHeaderSize;
        if (this.hasPreview) {
            this.extractDirectoryEntry(byArray, n, this.previewData);
            n += this.dirEntrySize;
        }
        int n4 = 0;
        while (n4 < this.nTiles) {
            this.tileData[n4] = new DirectoryEntry();
            this.extractDirectoryEntry(byArray, n, this.tileData[n4]);
            n += this.dirEntrySize;
            ++n4;
        }
    }

    protected void extractDirectoryEntry(byte[] byArray, int n, DirectoryEntry directoryEntry) {
        directoryEntry.nRow = this.extractInt2(byArray, n);
        directoryEntry.nCol = this.extractInt2(byArray, n + 2);
        directoryEntry.width = this.extractInt4(byArray, n + 4);
        directoryEntry.height = this.extractInt4(byArray, n + 8);
        directoryEntry.xPosInPano = this.extractInt4(byArray, n + 12);
        directoryEntry.yPosInPano = this.extractInt4(byArray, n + 16);
        directoryEntry.offset = this.extractInt4(byArray, n + 20);
        directoryEntry.size = this.extractInt4(byArray, n + 24);
        directoryEntry.wDeg = 1.0 * (double)directoryEntry.width * 360.0 / (double)this.pWidth;
        directoryEntry.hDeg = 1.0 * (double)directoryEntry.height * 360.0 / (double)this.pWidth;
    }

    protected int extractInt2(byte[] byArray, int n) {
        return this.unsignedByte2Int(byArray[n]) + (this.unsignedByte2Int(byArray[n + 1]) << 8);
    }

    protected int extractInt4(byte[] byArray, int n) {
        return this.unsignedByte2Int(byArray[n]) + (this.unsignedByte2Int(byArray[n + 1]) << 8) + (this.unsignedByte2Int(byArray[n + 2]) << 16) + (this.unsignedByte2Int(byArray[n + 3]) << 24);
    }

    protected int unsignedByte2Int(byte by) {
        return by & 0xFF;
    }

    protected class DirectoryEntry {
        int nRow;
        int nCol;
        int width;
        int height;
        int xPosInPano;
        int yPosInPano;
        int offset;
        int size;
        boolean loaded = false;
        double yaw;
        double pitch;
        double wDeg;
        double hDeg;
    }
}

