/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import java.util.Random;

public class BeHerePanViewer
extends Applet
implements Runnable,
ImageConsumer {
    private static final byte[] BH_LOGO_PIX;
    private static final byte[] BH_COLORS_RED;
    private static final byte[] BH_COLORS_GREEN;
    private static final byte[] BH_COLORS_BLUE;
    private Image bhTransparentLogoImage;
    private Image bhOpaqueLogoImage;
    private Image bhLogoImage;
    private Point bhLogoLocation;
    private Thread panThread;
    private boolean doRedraw = true;
    private boolean useMouseDrag = false;
    private Rectangle viewRect;
    private int latDir;
    private int vrtDir;
    private int zoomDir;
    private Point center;
    private Object inputNotify = new Object();
    private int gridWidth;
    private int gridHeight;
    private int[] gridX;
    private int[] gridY;
    private float elevUp = 0.87266463f;
    private float elevDn = -0.8290314f;
    private float elevSz;
    private float pprX;
    private float pprY;
    private float rppY;
    private float viewW2;
    private float viewH2;
    private int fpPanCenter;
    private int fpPanW;
    private int fpPanH;
    private float hAngle = 180.0f;
    private float vAngle = 0.08726646f;
    private float zFactor;
    private int[] viewPixels;
    private MemoryImageSource viewSource;
    private Image viewImage;
    private int panW;
    private int panH;
    private int[] panPixels;
    private Image panImage;
    private Image splashImage;
    private int logoOK = -1;
    private long logoStartTime;
    private MediaTracker mTracker;
    private Image bgTmp;
    private Image bgImage;
    private Graphics bgGraphics;
    private String errStr;

    public String getAppletInfo() {
        return "Applet Copyright\u00a9 1998-1999 Be Here Corporation v2.2c";
    }

    public void init() {
        Object object;
        this.viewRect = new Rectangle();
        try {
            this.viewRect.width = Integer.parseInt(this.getParameter("viewWidth"));
            this.viewRect.height = Integer.parseInt(this.getParameter("viewHeight"));
        }
        catch (Exception exception) {
            this.viewRect.width = this.size().width;
            this.viewRect.height = this.size().height;
        }
        this.viewW2 = this.viewRect.width / 2;
        this.viewH2 = this.viewRect.height / 2;
        if (this.viewRect.width % 16 != 0) {
            this.errStr = "Applet width or viewWidth not a multiple of 16";
            return;
        }
        if (this.viewRect.height % 32 != 0) {
            this.errStr = "Applet height or viewHeight not a multiple of 32";
            return;
        }
        try {
            this.viewRect.x = Integer.parseInt(this.getParameter("viewX"));
            this.viewRect.y = Integer.parseInt(this.getParameter("viewY"));
        }
        catch (Exception exception) {}
        this.viewPixels = new int[this.viewRect.width * this.viewRect.height];
        DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
        this.viewSource = new MemoryImageSource(this.viewRect.width, this.viewRect.height, (ColorModel)directColorModel, this.viewPixels, 0, this.viewRect.width);
        this.viewImage = this.createImage(this.viewSource);
        this.gridWidth = this.viewRect.width / 16;
        this.gridHeight = this.viewRect.height / 32;
        int n = (this.gridWidth + 1) * (this.gridHeight + 1);
        this.gridX = new int[n];
        this.gridY = new int[n];
        try {
            this.panImage = this.getImage(this.getDocumentBase(), this.getParameter("panImage"));
        }
        catch (Exception exception) {
            this.errStr = "Could not load panImage.";
            return;
        }
        this.panImage.getSource().startProduction(this);
        try {
            object = this.getParameter("logoImage");
            if (object == null) {
                object = "behere_logo.gif";
            }
            this.splashImage = this.getImage(this.getDocumentBase(), (String)object);
            this.mTracker = new MediaTracker(this);
            this.mTracker.addImage(this.splashImage, 1);
        }
        catch (Exception exception) {
            this.errStr = "Could not load required logoImage.";
            return;
        }
        try {
            this.bgTmp = this.getImage(this.getDocumentBase(), this.getParameter("backgroundImage"));
            this.mTracker.addImage(this.bgTmp, 1);
        }
        catch (Exception exception) {}
        try {
            this.latDir = 2 * Integer.parseInt(this.getParameter("autoSpin"));
        }
        catch (Exception exception) {}
        object = new IndexColorModel(2, 3, BH_COLORS_RED, BH_COLORS_GREEN, BH_COLORS_BLUE, 0);
        MemoryImageSource memoryImageSource = new MemoryImageSource(13, 15, (ColorModel)object, BH_LOGO_PIX, 0, 13);
        this.bhTransparentLogoImage = this.createImage(memoryImageSource);
        object = new IndexColorModel(2, 3, BH_COLORS_RED, BH_COLORS_GREEN, BH_COLORS_BLUE);
        memoryImageSource = new MemoryImageSource(13, 15, (ColorModel)object, BH_LOGO_PIX, 0, 13);
        this.bhLogoImage = this.bhOpaqueLogoImage = this.createImage(memoryImageSource);
        int n2 = this.viewRect.x + this.viewRect.width;
        int n3 = this.viewRect.y + this.viewRect.height;
        this.bhLogoLocation = new Point(n2 - 13 - this.viewRect.width / 24, n3 - 15 - this.viewRect.height / 18);
        this.center = new Point(n2 >> 1, n3 >> 1);
    }

    public void start() {
        if (this.mTracker != null) {
            try {
                this.mTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {}
            if (this.splashImage != null) {
                this.logoOK = this.verifyLogo(this.splashImage);
            }
            if (this.bgTmp != null) {
                this.bgImage = this.createImage(this.bgTmp.getWidth(null), this.bgTmp.getHeight(null));
                this.bgGraphics = this.bgImage.getGraphics();
                this.bgGraphics.drawImage(this.bgTmp, 0, 0, null);
                this.bgTmp.flush();
                this.bgTmp = null;
            }
            this.mTracker = null;
            if (this.splashImage != null) {
                this.repaint();
            }
        }
        if (this.panThread == null) {
            this.panThread = new Thread(this);
            this.panThread.start();
        }
    }

    public void stop() {
        if (this.panThread != null) {
            this.panThread.stop();
            this.panThread = null;
        }
    }

    public void destroy() {
        if (this.bgImage != null) {
            this.bgImage.flush();
            this.bgImage = null;
        }
        if (this.viewImage != null) {
            this.viewImage.flush();
            this.viewImage = null;
        }
        this.panPixels = null;
        this.viewPixels = null;
        System.gc();
        try {
            Thread.sleep(100L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public boolean keyDown(Event event, int n) {
        switch (event.key) {
            case 43: 
            case 65: 
            case 97: {
                this.zoomDir = 1;
                break;
            }
            case 45: 
            case 90: 
            case 122: {
                this.zoomDir = -1;
            }
        }
        Object object = this.inputNotify;
        synchronized (object) {
            this.inputNotify.notify();
        }
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        if (!this.useMouseDrag) {
            this.bhLogoImage = this.bhTransparentLogoImage;
            this.doRedraw = true;
        }
        this.requestFocus();
        Object object = this.inputNotify;
        synchronized (object) {
            this.inputNotify.notify();
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (!this.useMouseDrag) {
            this.latDir = 0;
            this.vrtDir = 0;
            this.bhLogoImage = this.bhOpaqueLogoImage;
            this.doRedraw = true;
        }
        this.showStatus("Applet Copyright\u00a9 1998-1999 Be Here Corporation v2.2c");
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (!this.useMouseDrag) {
            if (this.viewRect.inside(n, n2)) {
                this.latDir = n - this.center.x;
                this.vrtDir = this.center.y - n2;
                this.bhLogoImage = this.bhTransparentLogoImage;
            } else {
                this.latDir = 0;
                this.vrtDir = 0;
                this.bhLogoImage = this.bhOpaqueLogoImage;
            }
            this.doRedraw = true;
            if (this.latDir < 16 && this.vrtDir < 16 && this.latDir > -16 && this.vrtDir > -16) {
                this.latDir = 0;
                this.vrtDir = 0;
            }
        }
        Object object = this.inputNotify;
        synchronized (object) {
            this.inputNotify.notify();
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.latDir = n - this.center.x;
        this.vrtDir = this.center.y - n2;
        Object object = this.inputNotify;
        synchronized (object) {
            this.inputNotify.notify();
        }
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.useMouseDrag = true;
        this.center.x = n;
        this.center.y = n2;
        this.latDir = 0;
        this.vrtDir = 0;
        this.bhLogoImage = this.bhTransparentLogoImage;
        this.doRedraw = true;
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.useMouseDrag) {
            this.latDir = 0;
            this.vrtDir = 0;
            this.bhLogoImage = this.bhOpaqueLogoImage;
            this.doRedraw = true;
        }
        return true;
    }

    int verifyLogo(Image image) {
        int n;
        int n2;
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        int n5 = n3 * n4;
        int[] nArray = new int[n5];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n3, n4, nArray, 0, n3);
        try {
            if (!pixelGrabber.grabPixels()) {
                return 0;
            }
        }
        catch (InterruptedException interruptedException) {
            return 0;
        }
        try {
            long l;
            try {
                l = Long.valueOf(this.getParameter("logoKey"), 16);
            }
            catch (Exception exception) {
                l = 6636533175129900725L;
            }
            long l2 = (l & 0xF0F0F0F0F0F0F0L) >> 4;
            long l3 = (l & 0xF0F0F0F0F0F0FL) << 4;
            l = (l2 | l3 | l & 0xFF00000000000000L) ^ Long.MAX_VALUE;
            n2 = (int)((l & 0xFFFFFFFF00000000L) >> 32);
            n = (int)(l & 0xFFFFFFFFL);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        int n6 = n2 & 0xFF;
        if (n6 < 128) {
            n6 = 128;
        }
        Random random = new Random(n2);
        int n7 = 0;
        int n8 = n6;
        while (n8 != 0) {
            int n9 = random.nextInt() % nArray.length;
            if (n9 < 0) {
                n9 = -n9;
            }
            n7 += nArray[n9] & 0xFFFFFF;
            --n8;
        }
        if ((n7 &= Integer.MAX_VALUE) != n) {
            return 0;
        }
        return 1;
    }

    public void run() {
        Graphics graphics = this.getGraphics();
        this.adjView(0.0f, 0.0f, 0.0f);
        if (this.splashImage == null) {
            this.genView();
            this.drawView(graphics);
        } else {
            this.paint(graphics);
        }
        while (Thread.currentThread() == this.panThread) {
            if (this.splashImage == null && (this.latDir != 0 || this.vrtDir != 0 || this.zoomDir != 0 || this.panImage != null)) {
                this.adjView((float)this.latDir * 0.015f, (float)this.vrtDir * 0.005f, (float)this.zoomDir * 0.025f);
                this.zoomDir = 0;
                this.genView();
                this.doRedraw = true;
            }
            if (this.doRedraw) {
                this.doRedraw = false;
                this.drawView(graphics);
                if (this.panImage != null || this.splashImage != null) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                Thread.yield();
                continue;
            }
            try {
                Object object = this.inputNotify;
                synchronized (object) {
                    this.inputNotify.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void drawView(Graphics graphics) {
        if (this.splashImage != null) {
            if (this.logoStartTime != 0L || this.logoOK == 0) {
                long l = System.currentTimeMillis() - this.logoStartTime;
                if (this.panImage == null && l > 2000L || l > 5000L) {
                    this.splashImage.flush();
                    this.splashImage = null;
                }
            }
            this.doRedraw = true;
            return;
        }
        if (this.bgImage != null) {
            this.bgGraphics.drawImage(this.viewImage, this.viewRect.x, this.viewRect.y, null);
            graphics.drawImage(this.bgImage, 0, 0, null);
        } else {
            graphics.drawImage(this.viewImage, this.viewRect.x, this.viewRect.y, null);
        }
        graphics.drawImage(this.bhLogoImage, this.bhLogoLocation.x, this.bhLogoLocation.y, null);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.errStr != null) {
            Font font = new Font("Helvetica", 2, 12);
            graphics.getFontMetrics(font);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.size().width, this.size().height);
            graphics.setColor(Color.red);
            graphics.setFont(font);
            graphics.drawString("Error! " + this.errStr, 0, this.size().height / 2);
            return;
        }
        if (this.splashImage != null && this.logoOK == 1) {
            Graphics graphics2 = this.bgGraphics != null ? this.bgGraphics : graphics;
            graphics2.setColor(Color.white);
            graphics2.fillRect(this.viewRect.x, this.viewRect.y, this.viewRect.width, this.viewRect.height);
            graphics2.drawImage(this.splashImage, this.viewRect.x + this.viewRect.width - this.splashImage.getWidth(null) >> 1, this.viewRect.y + this.viewRect.height - this.splashImage.getHeight(null) >> 1, null);
            Font font = new Font("Helvetica", 0, 10);
            FontMetrics fontMetrics = graphics2.getFontMetrics(font);
            graphics2.setColor(Color.black);
            graphics2.setFont(font);
            graphics2.drawString("Loading PanImage\u2122...", this.viewRect.x + this.viewRect.width - fontMetrics.stringWidth("Loading PanImage\u2122...") >> 1, this.viewRect.y + this.viewRect.height - (fontMetrics.getHeight() << 1));
            if (this.logoStartTime == 0L) {
                this.logoStartTime = System.currentTimeMillis();
            }
            if (graphics2 != graphics) {
                graphics.drawImage(this.bgImage, 0, 0, null);
                return;
            }
        } else {
            this.drawView(graphics);
        }
    }

    public void setDimensions(int n, int n2) {
        float f;
        this.panW = n;
        this.panH = n2;
        this.panPixels = new int[this.panW * this.panH];
        try {
            this.elevUp = Float.valueOf(this.getParameter("elevUp")).floatValue();
            if ((double)this.elevUp > 1.0) {
                this.elevUp *= (float)Math.PI / 180;
            }
            this.elevDn = Float.valueOf(this.getParameter("elevDn")).floatValue();
            if ((double)this.elevDn < -1.0) {
                this.elevDn *= (float)Math.PI / 180;
            }
        }
        catch (Exception exception) {}
        this.elevSz = this.elevUp - this.elevDn;
        this.pprX = (float)((double)this.panW / (Math.PI * 2));
        this.pprY = (float)this.panH / this.elevSz;
        this.rppY = 1.0f / this.pprY;
        this.fpPanW = this.panW << 8;
        this.fpPanH = this.panH << 8;
        this.fpPanCenter = (int)((float)this.panH * (this.elevUp / this.elevSz)) << 8;
        this.zFactor = 324.0f / (float)this.panH;
        try {
            String string = this.getParameter("initialView");
            int n3 = string.indexOf(44, 0);
            f = Float.valueOf(string.substring(0, n3)).floatValue();
            int n4 = string.indexOf(44, n3 + 1);
            float f2 = Float.valueOf(string.substring(n3 + 1, n4)).floatValue();
            float f3 = Float.valueOf(string.substring(n4 + 1)).floatValue();
            this.vAngle = (float)Math.PI / 180 * f;
            this.hAngle = f2;
            this.zFactor = f3;
        }
        catch (Exception exception) {}
        float f4 = this.pprY / this.pprX;
        float f5 = (Math.min(this.elevUp - this.vAngle, this.vAngle - this.elevDn) - this.rppY) / f4;
        f = (float)((double)(f4 * this.viewH2) * Math.cos(f5) / (Math.sin(f5) * (double)this.pprX));
        if (this.zFactor < f) {
            this.zFactor = f;
        }
    }

    public void setHints(int n) {
    }

    public void setProperties(Hashtable hashtable) {
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        this.errStr = "Image loading format unsupported.";
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = n2 * this.panW + n;
        if (n3 == n6) {
            System.arraycopy(nArray, n5, this.panPixels, n7, n3 * n4);
            return;
        }
        int n8 = n4;
        while (n8 != 0) {
            System.arraycopy(nArray, n5, this.panPixels, n7, n3);
            n5 += n6;
            n7 += this.panW;
            --n8;
        }
    }

    public synchronized void imageComplete(int n) {
        switch (n) {
            case 1: {
                this.errStr = "Image loading failed w/IMAGEERROR";
                break;
            }
            case 4: {
                this.errStr = "Image loading failed w/IMAGEABORTED";
            }
        }
        this.panImage.getSource().removeConsumer(this);
        this.notifyAll();
        this.panImage.flush();
        this.panImage = null;
        this.adjView(0.0f, 0.0f, 0.0f);
        this.genView();
        this.doRedraw = true;
    }

    private void generateGrid() {
        float f = this.pprX * this.zFactor;
        float f2 = (float)Math.cos(-this.vAngle);
        float f3 = (float)Math.sin(-this.vAngle);
        float f4 = f * f2;
        float f5 = f * f3;
        float f6 = (float)this.panW * (this.hAngle / 360.0f) * 256.0f;
        int n = 0;
        float f7 = -this.viewH2;
        while (f7 <= this.viewH2) {
            float f8 = f4 - f7 * f3;
            float f9 = f5 + f7 * f2;
            float f10 = f8 * f8 + f9 * f9;
            float f11 = -this.viewW2;
            while (f11 <= this.viewW2) {
                this.gridX[n] = (int)(f6 + this.pprX * (float)Math.atan2(f11, f8) * 256.0f);
                this.gridY[n] = this.fpPanCenter + (int)(this.pprY * (float)Math.asin((double)f9 / Math.sqrt(f10 + f11 * f11)) * 256.0f);
                ++n;
                f11 += 16.0f;
            }
            f7 += 32.0f;
        }
    }

    private void adjView(float f, float f2, float f3) {
        this.hAngle += f;
        this.zFactor += f3;
        this.vAngle += f2 * ((float)Math.PI / 180);
        if (this.hAngle >= 360.0f) {
            this.hAngle = 0.0f;
        } else if (this.hAngle < 0.0f) {
            this.hAngle += 360.0f;
        }
        float f4 = (float)Math.atan2(this.viewH2, this.pprX * this.zFactor);
        float f5 = this.elevUp - f4 - this.rppY;
        float f6 = this.elevDn + f4 + this.rppY;
        if (f4 >= this.elevSz / 2.0f) {
            float f7 = this.elevSz / 2.0f - this.rppY;
            this.zFactor = this.viewH2 * (float)Math.cos(f7) / ((float)Math.sin(f7) * this.pprX);
            this.vAngle = (this.elevUp + this.elevDn) / 2.0f;
        } else if (this.vAngle >= f5) {
            this.vAngle = f5;
        } else if (this.vAngle <= f6) {
            this.vAngle = f6;
        }
        this.generateGrid();
    }

    private void genView() {
        if (this.panPixels == null) {
            return;
        }
        this.viewImage.flush();
        int n = 0;
        int n2 = 0;
        int n3 = this.gridWidth + 1;
        int n4 = this.gridHeight;
        while (n4 != 0) {
            int n5 = n;
            int n6 = this.gridWidth;
            while (n6 != 0) {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14 = this.gridX[n2];
                int n15 = this.gridX[n2 + 1];
                int n16 = this.gridX[n3];
                int n17 = this.gridX[n3 + 1];
                int n18 = this.gridY[n2];
                int n19 = this.gridY[n2 + 1];
                int n20 = this.gridY[n3];
                int n21 = this.gridY[n3 + 1];
                int n22 = n20 - n18 >> 5;
                int n23 = n16 - n14 >> 5;
                int n24 = n21 - n19 >> 5;
                int n25 = n17 - n15 >> 5;
                int n26 = n5;
                if (n17 >= this.fpPanW || n14 < 0 || n16 >= this.fpPanW || n15 < 0 || n15 >= this.fpPanW || n16 < 0 || n14 >= this.fpPanW || n17 < 0) {
                    n13 = 32;
                    while (n13 != 0) {
                        n12 = n19 - n18 >> 4;
                        n11 = n15 - n14 >> 4;
                        n10 = n14;
                        n9 = n18;
                        n8 = n26 + 16;
                        n7 = n26;
                        while (n7 != n8) {
                            if (n10 >= this.fpPanW) {
                                n10 -= this.fpPanW;
                            } else if (n10 < 0) {
                                n10 += this.fpPanW;
                            }
                            this.viewPixels[n7] = this.panPixels[(n9 >> 8) * this.panW + (n10 >> 8)];
                            n10 += n11;
                            n9 += n12;
                            ++n7;
                        }
                        n26 += this.viewRect.width;
                        n14 += n23;
                        n18 += n22;
                        n15 += n25;
                        n19 += n24;
                        --n13;
                    }
                } else {
                    n13 = 32;
                    while (n13 != 0) {
                        n12 = n19 - n18 >> 4;
                        n11 = n15 - n14 >> 4;
                        n10 = n14;
                        n9 = n18;
                        n8 = n26 + 16;
                        n7 = n26;
                        while (n7 != n8) {
                            this.viewPixels[n7] = this.panPixels[(n9 >> 8) * this.panW + (n10 >> 8)];
                            n10 += n11;
                            n9 += n12;
                            ++n7;
                        }
                        n26 += this.viewRect.width;
                        n14 += n23;
                        n18 += n22;
                        n15 += n25;
                        n19 += n24;
                        --n13;
                    }
                }
                ++n2;
                ++n3;
                n5 += 16;
                --n6;
            }
            ++n2;
            ++n3;
            n += this.viewRect.width << 5;
            --n4;
        }
    }

    static {
        byte[] byArray = new byte[195];
        byArray[3] = 2;
        byArray[4] = 2;
        byArray[5] = 2;
        byArray[6] = 2;
        byArray[7] = 2;
        byArray[8] = 2;
        byArray[9] = 2;
        byArray[16] = 2;
        byArray[17] = 2;
        byArray[18] = 2;
        byArray[19] = 2;
        byArray[20] = 2;
        byArray[21] = 2;
        byArray[22] = 2;
        byArray[26] = 1;
        byArray[27] = 1;
        byArray[28] = 1;
        byArray[36] = 1;
        byArray[37] = 1;
        byArray[38] = 1;
        byArray[39] = 1;
        byArray[40] = 1;
        byArray[41] = 1;
        byArray[49] = 1;
        byArray[50] = 1;
        byArray[51] = 1;
        byArray[52] = 1;
        byArray[53] = 1;
        byArray[54] = 1;
        byArray[55] = 1;
        byArray[56] = 1;
        byArray[57] = 1;
        byArray[58] = 1;
        byArray[59] = 1;
        byArray[60] = 1;
        byArray[61] = 1;
        byArray[62] = 1;
        byArray[63] = 1;
        byArray[64] = 1;
        byArray[65] = 1;
        byArray[66] = 1;
        byArray[67] = 1;
        byArray[75] = 1;
        byArray[76] = 1;
        byArray[77] = 1;
        byArray[78] = 2;
        byArray[90] = 2;
        byArray[91] = 2;
        byArray[92] = 2;
        byArray[102] = 2;
        byArray[103] = 2;
        byArray[104] = 2;
        byArray[105] = 2;
        byArray[106] = 2;
        byArray[114] = 2;
        byArray[115] = 2;
        byArray[116] = 2;
        byArray[117] = 2;
        byArray[118] = 2;
        byArray[119] = 2;
        byArray[120] = 2;
        byArray[126] = 2;
        byArray[127] = 2;
        byArray[128] = 2;
        byArray[129] = 2;
        byArray[130] = 2;
        byArray[131] = 2;
        byArray[132] = 2;
        byArray[133] = 2;
        byArray[134] = 2;
        byArray[138] = 2;
        byArray[139] = 2;
        byArray[140] = 2;
        byArray[141] = 2;
        byArray[142] = 2;
        byArray[143] = 2;
        byArray[144] = 2;
        byArray[145] = 2;
        byArray[146] = 2;
        byArray[147] = 2;
        byArray[148] = 2;
        byArray[150] = 2;
        byArray[151] = 2;
        byArray[152] = 2;
        byArray[153] = 2;
        byArray[154] = 2;
        byArray[155] = 2;
        byArray[162] = 1;
        byArray[174] = 1;
        byArray[175] = 1;
        byArray[176] = 1;
        byArray[188] = 1;
        BH_LOGO_PIX = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[0] = -1;
        byArray2[1] = -50;
        BH_COLORS_RED = byArray2;
        BH_COLORS_GREEN = new byte[]{-1, 57, 82};
        BH_COLORS_BLUE = new byte[]{-1, 57, 107};
    }
}

